<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= esc($title ?? 'Portofolio Diki') ?></title>
    <!-- Bootstrap 5 -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <!-- Custom CSS -->
    <link href="/css/style.css" rel="stylesheet">
</head>

<body>
    <nav class="navbar navbar-expand-lg fixed-top">
        <div class="container">
            <a class="navbar-brand" href="/">Portofolio<span style="color: var(--primary-color);">Diki</span></a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto align-items-center">
                    <li class="nav-item"><a class="nav-link" href="/">Beranda</a></li>
                    <li class="nav-item"><a class="nav-link" href="/activities">Aktivitas</a></li>
                    <li class="nav-item"><a class="nav-link" href="/cv">Biodata</a></li>
                    <li class="nav-item"><a class="nav-link" href="/education">Pendidikan</a></li>
                    <li class="nav-item ms-lg-3"><a class="nav-link btn-login" href="/login">Masuk</a></li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div style="margin-top: 76px;">
        <?= $this->renderSection('content') ?>
    </div>

    <footer class="text-center">
        <div class="container">
            <p class="mb-0">&copy; <?= date('Y') ?> Portofolio Diki. Dibuat dengan CodeIgniter 4.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>