<?= $this->extend('admin/layout/template') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><?= esc($title) ?></h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/education" class="btn btn-sm btn-outline-secondary">Back</a>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <form action="<?= isset($item) ? '/admin/education/update/' . $item['id'] : '/admin/education/create' ?>"
            method="post">
            <?= csrf_field() ?>

            <div class="mb-3">
                <label class="form-label">Institution</label>
                <input type="text" name="institution" class="form-control"
                    value="<?= old('institution', $item['institution'] ?? '') ?>" required>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="form-label">Start Year</label>
                    <input type="number" name="start_year" class="form-control"
                        value="<?= old('start_year', $item['start_year'] ?? '') ?>" required>
                </div>
                <div class="col-md-6 mb-3">
                    <label class="form-label">End Year</label>
                    <input type="number" name="end_year" class="form-control"
                        value="<?= old('end_year', $item['end_year'] ?? '') ?>" placeholder="Leave empty if Present">
                </div>
            </div>

            <div class="mb-3">
                <label class="form-label">Description</label>
                <textarea name="description" class="form-control"
                    rows="4"><?= old('description', $item['description'] ?? '') ?></textarea>
            </div>

            <button type="submit" class="btn btn-primary">Save</button>
        </form>
    </div>
</div>
<?= $this->endSection() ?>