<?= $this->extend('admin/layout/template') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
    <h1 class="h2"><?= esc($title) ?></h1>
    <div class="btn-toolbar mb-2 mb-md-0">
        <a href="/admin/cv" class="btn btn-sm btn-outline-secondary">Back</a>
    </div>
</div>

<div class="row">
    <div class="col-md-6">
        <form action="<?= isset($item) ? '/admin/cv/update/' . $item['id'] : '/admin/cv/create' ?>" method="post">
            <?= csrf_field() ?>

            <div class="mb-3">
                <label class="form-label">Field Name (Key)</label>
                <input type="text" name="field_key" class="form-control"
                    value="<?= old('field_key', $item['field_key'] ?? '') ?>" placeholder="e.g. Full Name" required>
                <div class="form-text">Must be unique.</div>
            </div>

            <div class="mb-3">
                <label class="form-label">Value</label>
                <textarea name="field_value" class="form-control" rows="4"
                    required><?= old('field_value', $item['field_value'] ?? '') ?></textarea>
            </div>

            <button type="submit" class="btn btn-primary">Save</button>
        </form>
    </div>
</div>
<?= $this->endSection() ?>