<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class EducationSeeder extends Seeder
{
    public function run()
    {
        $data = [
            [
                'institution' => 'Sekolah Dasar (SD)',
                'start_year' => '2008',
                'end_year' => '2014',
                'description' => 'Pendidikan dasar.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'institution' => 'Sekolah Menengah Pertama (SMP)',
                'start_year' => '2014',
                'end_year' => '2017',
                'description' => 'Pendidikan menengah pertama.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'institution' => 'Sekolah Menengah Atas (SMA)',
                'start_year' => '2017',
                'end_year' => '2020',
                'description' => 'Jurusan IPA/IPS.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
            [
                'institution' => 'Universitas Yahya Mandiri (UYM)', // Assuming UYM, or keeping generic if unsure. Let's use UYM as requested.
                'start_year' => '2020',
                'end_year' => null, // Present
                'description' => 'Mahasiswa aktif.',
                'created_at' => date('Y-m-d H:i:s'),
                'updated_at' => date('Y-m-d H:i:s'),
            ],
        ];

        // Using Query Builder
        $this->db->table('education')->insertBatch($data);
    }
}
