<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Home::index');

// Auth Routes
$routes->get('/login', 'LoginController::index');
$routes->post('/login/auth', 'LoginController::auth');
$routes->get('/logout', 'LoginController::logout');

// Public Pages
$routes->get('/activities', 'Home::activities');
$routes->get('/cv', 'Home::cv');
$routes->get('/education', 'Home::education');

// Admin Routes
$routes->group('admin', ['namespace' => 'App\Controllers\Admin', 'filter' => 'auth'], function ($routes) {
    // Activity
    $routes->get('activities', 'ActivityController::index');
    $routes->get('activities/new', 'ActivityController::new');
    $routes->post('activities/create', 'ActivityController::create');
    $routes->get('activities/edit/(:num)', 'ActivityController::edit/$1');
    $routes->post('activities/update/(:num)', 'ActivityController::update/$1');
    $routes->get('activities/delete/(:num)', 'ActivityController::delete/$1');

    // Biodata / CV
    $routes->get('cv', 'BiodataController::index');
    $routes->get('cv/new', 'BiodataController::new');
    $routes->post('cv/create', 'BiodataController::create');
    $routes->get('cv/edit/(:num)', 'BiodataController::edit/$1');
    $routes->post('cv/update/(:num)', 'BiodataController::update/$1');
    $routes->get('cv/delete/(:num)', 'BiodataController::delete/$1');

    // Education
    $routes->get('education', 'EducationController::index');
    $routes->get('education/new', 'EducationController::new');
    $routes->post('education/create', 'EducationController::create');
    $routes->get('education/edit/(:num)', 'EducationController::edit/$1');
    $routes->post('education/update/(:num)', 'EducationController::update/$1');
    $routes->get('education/delete/(:num)', 'EducationController::delete/$1');
});
