<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $title ?? 'Portfolio' ?> - Creative CV</title>
    <link href="<?= base_url('css/style.css') ?>" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.13.3/dist/cdn.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/animejs/3.2.1/anime.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        .page-transition { opacity: 0; transform: translateY(30px); }
        .nav-scrolled { background: rgba(17, 24, 39, 0.95); backdrop-filter: blur(20px); box-shadow: 0 10px 40px rgba(0,0,0,0.3); }
    </style>
</head>
<body class="bg-gray-900 text-white font-sans antialiased overflow-x-hidden">

    <!-- Floating Particles Background -->
    <div class="fixed inset-0 overflow-hidden pointer-events-none z-0">
        <div class="absolute top-20 left-10 w-72 h-72 bg-primary/20 rounded-full filter blur-3xl animate-float"></div>
        <div class="absolute bottom-20 right-10 w-96 h-96 bg-secondary/20 rounded-full filter blur-3xl animate-float" style="animation-delay: 2s;"></div>
        <div class="absolute top-1/2 left-1/2 w-64 h-64 bg-pink-500/10 rounded-full filter blur-3xl animate-float" style="animation-delay: 4s;"></div>
    </div>

    <!-- Navigation -->
    <nav class="fixed w-full z-50 top-0 transition-all duration-500" id="navbar">
        <div class="container mx-auto px-6 md:px-12 py-4">
            <div class="glass-dark rounded-2xl px-6 py-3 flex justify-between items-center">
                <a href="<?= base_url('/') ?>" class="text-2xl font-bold tracking-tight hover:scale-105 transition-transform">
                    <span class="gradient-text">MY</span><span class="text-white">PORTFOLIO</span>
                </a>
                
                <?php $uri = uri_string(); ?>
                <div class="hidden md:flex items-center space-x-2">
                    <a href="<?= base_url('/') ?>" class="nav-link px-5 py-2.5 rounded-xl text-sm font-medium transition-all duration-300 <?= ($uri == '' || $uri == '/') ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'text-gray-300 hover:bg-white/10 hover:text-white' ?>">
                        <i class="fas fa-home mr-2"></i>Beranda
                    </a>
                    <a href="<?= base_url('profile') ?>" class="nav-link px-5 py-2.5 rounded-xl text-sm font-medium transition-all duration-300 <?= (strpos($uri, 'profile') !== false) ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'text-gray-300 hover:bg-white/10 hover:text-white' ?>">
                        <i class="fas fa-user mr-2"></i>Profil
                    </a>
                    <a href="<?= base_url('education') ?>" class="nav-link px-5 py-2.5 rounded-xl text-sm font-medium transition-all duration-300 <?= (strpos($uri, 'education') !== false) ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'text-gray-300 hover:bg-white/10 hover:text-white' ?>">
                        <i class="fas fa-graduation-cap mr-2"></i>Pendidikan
                    </a>
                    <a href="<?= base_url('activities') ?>" class="nav-link px-5 py-2.5 rounded-xl text-sm font-medium transition-all duration-300 <?= (strpos($uri, 'activities') !== false) ? 'bg-primary text-white shadow-lg shadow-primary/30' : 'text-gray-300 hover:bg-white/10 hover:text-white' ?>">
                        <i class="fas fa-camera mr-2"></i>Aktivitas
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <button id="mobile-menu-btn" class="md:hidden p-2 rounded-lg hover:bg-white/10 transition-colors">
                    <i class="fas fa-bars text-xl"></i>
                </button>
            </div>
        </div>
    </nav>

    <!-- Mobile Menu -->
    <div id="mobile-menu" class="fixed inset-0 bg-gray-900/98 backdrop-blur-xl z-40 transform translate-x-full transition-transform duration-500 md:hidden flex flex-col justify-center items-center space-y-6">
        <a href="<?= base_url('/') ?>" class="text-2xl font-bold px-8 py-4 rounded-2xl <?= ($uri == '' || $uri == '/') ? 'bg-primary text-white' : 'text-gray-300 hover:bg-white/10' ?> transition-all">
            <i class="fas fa-home mr-3"></i>Beranda
        </a>
        <a href="<?= base_url('profile') ?>" class="text-2xl font-bold px-8 py-4 rounded-2xl <?= (strpos($uri, 'profile') !== false) ? 'bg-primary text-white' : 'text-gray-300 hover:bg-white/10' ?> transition-all">
            <i class="fas fa-user mr-3"></i>Profil
        </a>
        <a href="<?= base_url('education') ?>" class="text-2xl font-bold px-8 py-4 rounded-2xl <?= (strpos($uri, 'education') !== false) ? 'bg-primary text-white' : 'text-gray-300 hover:bg-white/10' ?> transition-all">
            <i class="fas fa-graduation-cap mr-3"></i>Pendidikan
        </a>
        <a href="<?= base_url('activities') ?>" class="text-2xl font-bold px-8 py-4 rounded-2xl <?= (strpos($uri, 'activities') !== false) ? 'bg-primary text-white' : 'text-gray-300 hover:bg-white/10' ?> transition-all">
            <i class="fas fa-camera mr-3"></i>Aktivitas
        </a>
        <button id="close-menu-btn" class="absolute top-6 right-6 w-12 h-12 bg-white/10 rounded-full flex items-center justify-center hover:bg-red-500 transition-all">
            <i class="fas fa-times text-2xl"></i>
        </button>
    </div>

    <!-- Main Content -->
    <main class="pt-28 min-h-screen relative z-10">
        <?= $this->renderSection('content') ?>
    </main>

    <!-- Premium Footer -->
    <footer class="relative z-10 mt-20">
        <div class="bg-gradient-to-t from-gray-950 to-gray-900 border-t border-gray-800">
            <div class="container mx-auto px-6 py-12">
                <div class="flex flex-col md:flex-row justify-between items-center gap-6">
                    <div class="text-center md:text-left">
                        <h3 class="text-2xl font-bold gradient-text">MYPORTFOLIO</h3>
                    </div>
                    <div class="flex items-center space-x-4">
                        <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-primary rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110">
                            <i class="fab fa-github"></i>
                        </a>
                        <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-blue-500 rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110">
                            <i class="fab fa-linkedin-in"></i>
                        </a>
                        <a href="#" class="w-10 h-10 bg-gray-800 hover:bg-pink-500 rounded-full flex items-center justify-center transition-all duration-300 hover:scale-110">
                            <i class="fab fa-instagram"></i>
                        </a>
                    </div>
                </div>
                <div class="mt-8 pt-6 border-t border-gray-800 text-center text-gray-600 text-sm">
                    &copy; <?= date('Y') ?> Muhamad Abdul Aziz. All rights reserved.
                </div>
            </div>
        </div>
    </footer>

    <script>
        // Navbar Scroll Effect
        window.addEventListener('scroll', () => {
            const nav = document.getElementById('navbar');
            if (window.scrollY > 50) {
                nav.classList.add('bg-gray-900', 'shadow-lg');
            } else {
                nav.classList.remove('bg-gray-900', 'shadow-lg');
            }
        });

        // Mobile Menu
        const mobileBtn = document.getElementById('mobile-menu-btn');
        const closeBtn = document.getElementById('close-menu-btn');
        const menu = document.getElementById('mobile-menu');

        mobileBtn.addEventListener('click', () => {
            menu.classList.remove('translate-x-full');
        });

        closeBtn.addEventListener('click', () => {
            menu.classList.add('translate-x-full');
        });

        // Page Transition Animation
        document.addEventListener('DOMContentLoaded', () => {
            anime({
                targets: '.page-transition',
                translateY: [20, 0],
                opacity: [0, 1],
                duration: 800,
                easing: 'easeOutExpo',
                delay: anime.stagger(100)
            });
        });

        // Search Warning Alert (using session 'message' set by controllers)
        <?php if(session()->getFlashdata('message')): ?>
            Swal.fire({
                icon: 'warning',
                title: 'Note',
                text: '<?= session()->getFlashdata('message') ?>',
                confirmButtonColor: '#4f46e5'
            });
        <?php endif; ?>
    </script>
</body>
</html>
