<?= $this->extend('layouts/backend') ?>

<?= $this->section('content') ?>

<div class="container mx-auto px-6 py-8">
    <div class="flex justify-between items-center mb-6">
        <h3 class="text-gray-800 text-3xl font-bold"><?= $title ?></h3>
        <a href="<?= base_url('admin/activity') ?>" class="flex items-center text-gray-600 hover:text-indigo-600 transition-colors">
            <i class="fas fa-arrow-left mr-2"></i> Kembali
        </a>
    </div>

    <div class="bg-white p-8 rounded-2xl shadow-lg border border-gray-100">
        <?php if(session()->getFlashdata('errors')): ?>
            <div class="bg-red-50 border-l-4 border-red-500 text-red-700 p-4 mb-6 rounded-r">
                <div class="font-bold mb-2"><i class="fas fa-exclamation-circle mr-2"></i> Ada Kesalahan:</div>
                <ul class="list-disc list-inside text-sm">
                    <?php foreach (session()->getFlashdata('errors') as $error): ?>
                        <li><?= esc($error) ?></li>
                    <?php endforeach ?>
                </ul>
            </div>
        <?php endif; ?>

        <form action="<?= isset($activity) ? base_url('admin/activity/' . $activity['id'] . '/update') : base_url('admin/activity/create') ?>" method="post" enctype="multipart/form-data">
            <?= csrf_field() ?>
            
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <!-- Date -->
                <div class="mb-4">
                    <label for="date" class="block text-gray-700 font-bold mb-2">Tanggal</label>
                    <input type="date" name="date" id="date" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($activity) ? esc($activity['date']) : old('date') ?>" required>
                </div>

                <!-- Time -->
                <div class="mb-4">
                    <label for="time" class="block text-gray-700 font-bold mb-2">Waktu</label>
                    <input type="time" name="time" id="time" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($activity) ? esc($activity['time']) : old('time') ?>" required>
                </div>

                <!-- Activity Name -->
                <div class="mb-4 md:col-span-2">
                    <label for="activity_name" class="block text-gray-700 font-bold mb-2">Nama Aktivitas</label>
                    <input type="text" name="activity_name" id="activity_name" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" value="<?= isset($activity) ? esc($activity['activity_name']) : old('activity_name') ?>" required placeholder="Contoh: Belajar Coding">
                </div>

                <!-- Description -->
                <div class="mb-4 md:col-span-2">
                    <label for="description" class="block text-gray-700 font-bold mb-2">Deskripsi</label>
                    <textarea name="description" id="description" rows="3" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all" placeholder="Jelaskan aktivitas Anda..."><?= isset($activity) ? esc($activity['description']) : old('description') ?></textarea>
                </div>

                <!-- Media Type -->
                <div class="mb-4">
                    <label for="media_type" class="block text-gray-700 font-bold mb-2">Tipe Media</label>
                    <select name="media_type" id="media_type" class="w-full px-4 py-3 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-primary focus:border-transparent transition-all">
                        <option value="none" <?= (isset($activity) && $activity['media_type'] == 'none') ? 'selected' : '' ?>>Tidak Ada</option>
                        <option value="photo" <?= (isset($activity) && $activity['media_type'] == 'photo') ? 'selected' : '' ?>>Foto</option>
                        <option value="video" <?= (isset($activity) && $activity['media_type'] == 'video') ? 'selected' : '' ?>>Video</option>
                    </select>
                </div>

                <!-- Media Upload -->
                <div class="mb-6">
                    <label for="media_path" class="block text-gray-700 font-bold mb-2">Unggah Media (Opsional)</label>
                    <?php if(isset($activity) && $activity['media_path']): ?>
                        <div class="mb-2 text-sm text-green-600 font-medium"><i class="fas fa-file-check mr-1"></i> File saat ini: <?= basename($activity['media_path']) ?></div>
                    <?php endif; ?>
                    <div class="relative">
                         <input type="file" name="media_path" id="media_path" class="block w-full text-sm text-gray-500
                                file:mr-4 file:py-2 file:px-4
                                file:rounded-full file:border-0
                                file:text-sm file:font-semibold
                                file:bg-primary file:text-white
                                hover:file:bg-indigo-700
                                cursor-pointer
                            ">
                    </div>
                </div>
            </div>

            <div class="mt-6 flex justify-end">
                <button type="submit" class="bg-primary hover:bg-indigo-700 text-white font-bold py-3 px-8 rounded-xl shadow-lg transform hover:-translate-y-0.5 transition-all duration-200">
                    <i class="fas fa-save mr-2"></i> Simpan Aktivitas
                </button>
            </div>
        </form>
    </div>
</div>

<?= $this->endSection() ?>
