<?= $this->extend('layout/frontend') ?>

<?= $this->section('content') ?>

<!-- Hero Section -->
<section class="relative bg-white overflow-hidden rounded-3xl shadow-2xl mb-12 border border-primary-50">
    <div class="absolute inset-0">
        <div class="absolute inset-0 bg-gradient-to-r from-primary-800 to-primary-600 opacity-90"></div>
        <!-- Decorative blob -->
        <div
            class="absolute top-0 left-0 -ml-24 -mt-24 w-96 h-96 rounded-full bg-primary-400 blur-3xl opacity-30 mix-blend-overlay animate-blob">
        </div>
        <div
            class="absolute bottom-0 right-0 -mr-24 -mb-24 w-96 h-96 rounded-full bg-sky-400 blur-3xl opacity-30 mix-blend-overlay animate-blob animation-delay-2000">
        </div>
    </div>

    <div class="relative max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-24 sm:py-32 flex flex-col items-center text-center">
        <span
            class="inline-block py-1 px-4 rounded-full bg-white/20 text-white text-sm font-semibold mb-6 border border-white/20 backdrop-blur-md">
            ✨ Selamat Datang di Dunia Saya
        </span>
        <h1 class="text-4xl md:text-6xl font-extrabold text-white tracking-tight mb-6 drop-shadow-sm">
            Hi, I'm <span class="text-transparent bg-clip-text bg-gradient-to-r from-sky-200 to-white">
                   Aul</span>
        </h1>
        <p class="mt-4 max-w-2xl text-xl text-primary-100 mx-auto font-light leading-relaxed">
            Menjelajahi dunia melalui aktivitas harian dan perjalanan hidup yang penuh warna.
        </p>
        <div class="mt-10 flex flex-wrap gap-4 justify-center">
            <a href="/biodata"
                class="px-8 py-3.5 rounded-full bg-white text-primary-600 font-bold hover:bg-primary-50 transition-all transform hover:-translate-y-1 shadow-lg hover:shadow-xl">
                Lihat Profil
            </a>
            <a href="/activities"
                class="px-8 py-3.5 rounded-full bg-primary-700/50 border border-white/30 text-white font-bold hover:bg-primary-700/70 transition-all transform hover:-translate-y-1 backdrop-blur-sm">
                Aktivitas Terbaru
            </a>
        </div>
    </div>
</section>

<!-- Features Grid -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-8 mb-12">
    <!-- Card 1 -->
    <a href="/activities"
        class="group block p-8 bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 border border-primary-50 relative overflow-hidden">
        <div
            class="absolute top-0 right-0 -mt-4 -mr-4 w-32 h-32 bg-primary-100 rounded-full blur-2xl group-hover:bg-primary-200 transition-colors opacity-60">
        </div>
        <div class="relative z-10">
            <div
                class="w-14 h-14 bg-primary-50 text-primary-600 rounded-2xl flex items-center justify-center text-3xl mb-6 group-hover:scale-110 transition-transform shadow-sm">
                📸
            </div>
            <h3 class="text-2xl font-bold text-gray-900 mb-2 group-hover:text-primary-600 transition-colors">Aktivitas
                Harian</h3>
            <p class="text-gray-500 leading-relaxed">Lihat galeri foto dan catatan kegiatan sehari-hari saya.</p>
        </div>
    </a>

    <!-- Card 2 -->
    <a href="/biodata"
        class="group block p-8 bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 border border-primary-50 relative overflow-hidden">
        <div
            class="absolute top-0 right-0 -mt-4 -mr-4 w-32 h-32 bg-sky-100 rounded-full blur-2xl group-hover:bg-sky-200 transition-colors opacity-60">
        </div>
        <div class="relative z-10">
            <div
                class="w-14 h-14 bg-sky-50 text-sky-600 rounded-2xl flex items-center justify-center text-3xl mb-6 group-hover:scale-110 transition-transform shadow-sm">
                👤
            </div>
            <h3 class="text-2xl font-bold text-gray-900 mb-2 group-hover:text-sky-600 transition-colors">Biodata Diri
            </h3>
            <p class="text-gray-500 leading-relaxed">Profil lengkap, kontak, dan ringkasan profesional saya.</p>
        </div>
    </a>

    <!-- Card 3 -->
    <a href="/education"
        class="group block p-8 bg-white rounded-3xl shadow-xl hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 border border-primary-50 relative overflow-hidden">
        <div
            class="absolute top-0 right-0 -mt-4 -mr-4 w-32 h-32 bg-blue-100 rounded-full blur-2xl group-hover:bg-blue-200 transition-colors opacity-60">
        </div>
        <div class="relative z-10">
            <div
                class="w-14 h-14 bg-blue-50 text-blue-600 rounded-2xl flex items-center justify-center text-3xl mb-6 group-hover:scale-110 transition-transform shadow-sm">
                🎓
            </div>
            <h3 class="text-2xl font-bold text-gray-900 mb-2 group-hover:text-blue-600 transition-colors">Pendidikan
            </h3>
            <p class="text-gray-500 leading-relaxed">Jejak langkah akademis dari sekolah dasar hingga perguruan tinggi.
            </p>
        </div>
    </a>
</div>

<?= $this->endSection() ?>