<?= $this->extend('layout/frontend') ?>

<?= $this->section('content') ?>

<div class="mb-8 flex flex-col md:flex-row md:items-center justify-between gap-4">
    <div>
        <h1 class="text-3xl font-bold text-gray-900">Riwayat Pendidikan</h1>
        <p class="text-gray-500 mt-1">Jejak akademis dari masa ke masa.</p>
    </div>
    <form action="" method="get" class="flex items-center gap-2 bg-white p-2 rounded-lg shadow-sm border">
        <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari sekolah..."
            class="px-4 py-2 outline-none text-gray-700 w-full md:w-64">
        <button type="submit" class="bg-primary-600 text-white p-2 rounded hover:bg-primary-700 transition">🔍</button>
    </form>
</div>

<?php if (empty($education)): ?>
    <div class="bg-white rounded-xl shadow-lg p-12 text-center text-gray-500">
        Data pendidikan belum tersedia.
    </div>
<?php else: ?>
    <div class="relative max-w-4xl mx-auto">
        <!-- Vertical Line -->
        <div class="absolute left-8 top-0 bottom-0 w-0.5 bg-primary-200 hidden md:block"></div>

        <div class="space-y-12">
            <?php foreach ($education as $item): ?>
                <div class="relative flex flex-col md:flex-row gap-10 items-start group">
                    <!-- Dot with Pulse Effect -->
                    <div
                        class="absolute left-8 -ml-3.5 w-7 h-7 rounded-full border-4 border-white bg-primary-500 shadow-lg hidden md:block group-hover:bg-primary-700 transition-colors z-10 ring-2 ring-primary-100">
                    </div>
                    <div
                        class="absolute left-8 -ml-3.5 w-7 h-7 rounded-full bg-primary-400 opacity-0 group-hover:opacity-40 animate-ping hidden md:block">
                    </div>

                    <div class="w-full md:pl-20">
                        <div
                            class="bg-white p-8 rounded-3xl shadow-lg hover:shadow-2xl transition-all duration-300 border border-primary-50 hover:border-primary-200 relative overflow-hidden group-odd:bg-white group-even:bg-primary-50/30">
                            <!-- Decorative background icon -->
                            <div
                                class="absolute -right-6 -bottom-6 text-9xl text-primary-100 opacity-20 pointer-events-none transform rotate-12 group-hover:rotate-0 transition-transform duration-500">
                                🎓
                            </div>

                            <div class="flex flex-col sm:flex-row justify-between sm:items-center mb-4 relative z-10">
                                <span
                                    class="inline-block px-4 py-1.5 bg-gradient-to-r from-primary-100 to-blue-100 text-primary-700 rounded-full text-xs font-bold tracking-wide uppercase mb-2 sm:mb-0 shadow-sm border border-primary-200">
                                    <?= esc($item['level']) ?>
                                </span>
                                <span
                                    class="text-sm font-semibold text-gray-400 bg-white/80 backdrop-blur px-3 py-1 rounded-lg border border-gray-100">
                                    <?= esc($item['start_year']) ?> - <?= esc($item['end_year']) ?>
                                </span>
                            </div>
                            <h3
                                class="text-2xl font-bold text-gray-900 mb-3 relative z-10 group-hover:text-primary-600 transition-colors">
                                <?= esc($item['school_name']) ?>
                            </h3>
                            <?php if (!empty($item['description'])): ?>
                                <p class="text-gray-600 leading-relaxed relative z-10 text-lg font-light">
                                    <?= nl2br(esc($item['description'])) ?>
                                </p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>

    <!-- Pagination -->
    <div class="mt-12 flex justify-center">
        <?= $pager->links() ?>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>