<?= $this->extend('layout/frontend') ?>

<?= $this->section('content') ?>

<div class="mb-10 flex flex-col md:flex-row md:items-center justify-between gap-4">
    <div>
        <h1 class="text-4xl font-extrabold text-gray-900 tracking-tight">Aktivitas Harian</h1>
        <p class="text-primary-400 mt-2 text-lg font-medium">Catatan kegiatan dan dokumentasi harian.</p>
    </div>
    <form action="" method="get"
        class="flex items-center gap-2 bg-white p-2 rounded-full shadow border border-primary-50">
        <input type="text" name="search" value="<?= esc($search) ?>" placeholder="Cari aktivitas..."
            class="px-6 py-2 outline-none text-gray-600 bg-transparent w-full md:w-64 placeholder-sky-200">
        <button type="submit"
            class="bg-primary-600 text-white p-2.5 rounded-full hover:bg-primary-700 transition shadow-md hover:shadow-lg transform hover:-translate-y-0.5">
            <svg xmlns="http://www.w3.org/2000/svg" class="h-5 w-5" fill="none" viewBox="0 0 24 24"
                stroke="currentColor">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                    d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z" />
            </svg>
        </button>
    </form>
</div>

<!-- Filters/Sorting Links -->
<div class="mb-8 flex gap-6 text-sm font-medium border-b border-primary-100 pb-4">
    <a href="?sort=date&order=DESC"
        class="text-primary-600 hover:text-primary-800 transition border-b-2 border-primary-500 pb-4 -mb-4.5">Terbaru</a>
    <a href="?sort=date&order=ASC" class="text-gray-400 hover:text-primary-500 transition">Terlama</a>
</div>

<?php if (empty($activities)): ?>
    <div class="bg-white rounded-3xl shadow-lg p-16 text-center text-gray-400 border border-primary-50">
        <p class="text-xl">Belum ada aktivitas yang ditemukan.</p>
    </div>
<?php else: ?>
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
        <?php foreach ($activities as $item): ?>
            <div
                class="group bg-white rounded-3xl shadow-lg hover:shadow-2xl transition-all duration-300 transform hover:-translate-y-2 overflow-hidden border border-primary-50 flex flex-col h-full relative">
                <div class="h-72 overflow-hidden relative">
                    <?php if (!empty($item['media_path'])): ?>
                        <img src="/uploads/activities/<?= esc($item['media_path']) ?>" alt="<?= esc($item['activity_name']) ?>"
                            class="w-full h-full object-cover transition-transform duration-700 group-hover:scale-110">
                    <?php else: ?>
                        <div class="w-full h-full flex items-center justify-center bg-gradient-to-br from-sky-50 to-blue-50">
                            <span
                                class="text-6xl opacity-30 grayscale group-hover:grayscale-0 transition-all duration-500">📷</span>
                        </div>
                    <?php endif; ?>
                    <div
                        class="absolute inset-0 bg-gradient-to-t from-primary-900/80 via-transparent to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300">
                        <div class="absolute bottom-4 left-4 text-white">
                            <p class="text-xs font-bold uppercase tracking-widest text-primary-200 mb-1">Uploaded</p>
                            <p class="text-lg font-bold"><?= date('d F Y', strtotime($item['date'])) ?></p>
                        </div>
                    </div>
                </div>
                <!-- Floating Date Badge -->
                <div
                    class="absolute top-4 right-4 bg-white/90 backdrop-blur-sm px-4 py-1.5 rounded-full text-xs font-bold text-primary-600 shadow-sm border border-white/50">
                    <?= date('d M Y', strtotime($item['date'])) ?>
                </div>

                <div class="p-8 flex-grow flex flex-col relative z-20 bg-white">
                    <div class="flex items-center text-xs font-bold text-primary-500 mb-3 tracking-wide uppercase gap-2">
                        <span class="bg-primary-50 px-2 py-0.5 rounded text-primary-600 border border-primary-100">Daily</span>
                        <span>•</span>
                        <span><?= date('H:i', strtotime($item['time'])) ?> WIB</span>
                    </div>
                    <h3
                        class="text-2xl font-bold text-gray-900 mb-3 group-hover:text-primary-600 transition-colors leading-tight">
                        <?= esc($item['activity_name']) ?>
                    </h3>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <!-- Pagination -->
    <div class="mt-12 flex justify-center">
        <?= $pager->links() ?>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>