<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow">
    <h2 class="text-2xl font-bold mb-6 text-gray-800">Edit Pendidikan</h2>

    <form action="/admin/education/<?= $education['id'] ?>" method="post">
        <input type="hidden" name="_method" value="PUT">

        <div class="mb-4">
            <label class="block text-gray-700 font-medium mb-2">Jenjang</label>
            <select name="level" class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
                <?php foreach (['SD', 'SMP', 'SMA', 'D3', 'S1', 'S2'] as $lvl): ?>
                    <option value="<?= $lvl ?>" <?= old('level', $education['level']) == $lvl ? 'selected' : '' ?>><?= $lvl ?>
                    </option>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="mb-4">
            <label class="block text-gray-700 font-medium mb-2">Nama Sekolah / Kampus</label>
            <input type="text" name="school_name" value="<?= old('school_name', $education['school_name']) ?>"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
        </div>

        <div class="grid grid-cols-2 gap-4 mb-4">
            <div>
                <label class="block text-gray-700 font-medium mb-2">Tahun Masuk</label>
                <input type="number" name="start_year" value="<?= old('start_year', $education['start_year']) ?>"
                    class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
            </div>
            <div>
                <label class="block text-gray-700 font-medium mb-2">Tahun Lulus</label>
                <input type="number" name="end_year" value="<?= old('end_year', $education['end_year']) ?>"
                    class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
            </div>
        </div>

        <div class="mb-6">
            <label class="block text-gray-700 font-medium mb-2">Deskripsi (Jurusan / Prestasi)</label>
            <textarea name="description" rows="3"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none"><?= old('description', $education['description']) ?></textarea>
        </div>

        <div class="flex justify-end gap-2">
            <a href="/admin/education" class="px-4 py-2 text-gray-600 hover:bg-gray-100 rounded">Batal</a>
            <button type="submit"
                class="px-6 py-2 bg-purple-600 text-white rounded hover:bg-purple-700 shadow">Update</button>
        </div>
    </form>
</div>

<?= $this->endSection() ?>