<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow">
    <h2 class="text-2xl font-bold mb-6 text-gray-800">Tambah Pendidikan</h2>

    <form action="/admin/education" method="post">
        <div class="mb-4">
            <label class="block text-gray-700 font-medium mb-2">Jenjang</label>
            <select name="level" class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
                <option value="SD" <?= old('level') == 'SD' ? 'selected' : '' ?>>SD</option>
                <option value="SMP" <?= old('level') == 'SMP' ? 'selected' : '' ?>>SMP</option>
                <option value="SMA" <?= old('level') == 'SMA' ? 'selected' : '' ?>>SMA / SMK</option>
                <option value="D3" <?= old('level') == 'D3' ? 'selected' : '' ?>>D3</option>
                <option value="S1" <?= old('level') == 'S1' ? 'selected' : '' ?>>S1</option>
                <option value="S2" <?= old('level') == 'S2' ? 'selected' : '' ?>>S2</option>
            </select>
        </div>

        <div class="mb-4">
            <label class="block text-gray-700 font-medium mb-2">Nama Sekolah / Kampus</label>
            <input type="text" name="school_name" value="<?= old('school_name') ?>"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
        </div>

        <div class="grid grid-cols-2 gap-4 mb-4">
            <div>
                <label class="block text-gray-700 font-medium mb-2">Tahun Masuk</label>
                <input type="number" name="start_year" value="<?= old('start_year') ?>"
                    class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
            </div>
            <div>
                <label class="block text-gray-700 font-medium mb-2">Tahun Lulus</label>
                <input type="number" name="end_year" value="<?= old('end_year') ?>"
                    class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
            </div>
        </div>

        <div class="mb-6">
            <label class="block text-gray-700 font-medium mb-2">Deskripsi (Jurusan / Prestasi)</label>
            <textarea name="description" rows="3"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none"><?= old('description') ?></textarea>
        </div>

        <div class="flex justify-end gap-2">
            <a href="/admin/education" class="px-4 py-2 text-gray-600 hover:bg-gray-100 rounded">Batal</a>
            <button type="submit"
                class="px-6 py-2 bg-purple-600 text-white rounded hover:bg-purple-700 shadow">Simpan</button>
        </div>
    </form>
</div>

<?= $this->endSection() ?>