<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="mb-8">
    <h1 class="text-3xl font-extrabold text-gray-900">Dashboard Overview</h1>
    <p class="text-gray-500 mt-1">Selamat datang kembali, Aul! Berikut ringkasan portfolio Anda.</p>
</div>

<!-- Stats Grid -->
<div class="grid grid-cols-1 md:grid-cols-3 gap-6 mb-12">
    <!-- Activity Card -->
    <div class="bg-white rounded-2xl shadow-sm border border-primary-100 p-6 flex items-center gap-6 transition hover:shadow-md hover:-translate-y-1">
        <div class="w-16 h-16 rounded-full bg-primary-50 flex items-center justify-center text-3xl shadow-inner">
            📅
        </div>
        <div>
            <h3 class="text-gray-400 font-medium text-sm uppercase tracking-wide">Aktivitas Harian</h3>
            <p class="text-4xl font-bold text-gray-800"><?= $countActivity ?></p>
        </div>
    </div>

    <!-- Biodata Card -->
    <div class="bg-white rounded-2xl shadow-sm border border-sky-100 p-6 flex items-center gap-6 transition hover:shadow-md hover:-translate-y-1">
        <div class="w-16 h-16 rounded-full bg-sky-50 flex items-center justify-center text-3xl shadow-inner">
            👤
        </div>
        <div>
            <h3 class="text-gray-400 font-medium text-sm uppercase tracking-wide">Biodata / CV</h3>
            <p class="text-4xl font-bold text-gray-800"><?= $countBiodata ?></p>
        </div>
    </div>

    <!-- Education Card -->
    <div class="bg-white rounded-2xl shadow-sm border border-blue-100 p-6 flex items-center gap-6 transition hover:shadow-md hover:-translate-y-1">
        <div class="w-16 h-16 rounded-full bg-blue-50 flex items-center justify-center text-3xl shadow-inner">
            🎓
        </div>
        <div>
            <h3 class="text-gray-400 font-medium text-sm uppercase tracking-wide">Riwayat Pendidikan</h3>
            <p class="text-4xl font-bold text-gray-800"><?= $countEducation ?></p>
        </div>
    </div>
</div>

<!-- Quick Actions -->
<div class="bg-gradient-to-r from-primary-500 to-blue-600 rounded-3xl p-8 text-white relative overflow-hidden shadow-lg">
    <div class="absolute top-0 right-0 w-64 h-64 bg-white opacity-10 rounded-full blur-3xl -mr-16 -mt-16"></div>
    
    <div class="relative z-10 flex flex-col md:flex-row items-center justify-between gap-6">
        <div>
            <h2 class="text-2xl font-bold mb-2">Kelola Konten Portfolio</h2>
            <p class="text-blue-100 max-w-lg">Akses cepat untuk menambah atau memperbarui data aktivitas, biodata, dan pendidikan Anda.</p>
        </div>
        <div class="flex flex-wrap gap-4">
            <a href="/admin/activity/new" class="px-6 py-3 bg-white text-primary-600 rounded-xl font-bold shadow-lg hover:bg-primary-50 transition transform hover:scale-105">
                + Aktivitas
            </a>
            <a href="/admin/biodata/new" class="px-6 py-3 bg-primary-700 bg-opacity-40 text-white border border-primary-400 rounded-xl font-bold hover:bg-opacity-60 transition transform hover:scale-105">
                + Biodata
            </a>
        </div>
    </div>
</div>

<?= $this->endSection() ?>