<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow">
    <h2 class="text-2xl font-bold mb-6 text-gray-800">Edit Biodata</h2>

    <form action="/admin/biodata/update/<?= esc($biodata['id']) ?>" method="post" enctype="multipart/form-data">
        <?= csrf_field() ?>

        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-bold mb-2">Foto Profil (Biarkan kosong jika tidak ingin
                mengganti)</label>
            <?php if (!empty($biodata['photo'])): ?>
                <div class="mb-2">
                    <img src="/uploads/biodata/<?= esc($biodata['photo']) ?>"
                        class="w-24 h-24 object-cover rounded-full border">
                </div>
            <?php endif; ?>
            <input type="file" name="photo"
                class="w-full px-3 py-2 border rounded-lg focus:outline-none focus:border-purple-500">
        </div>

        <div class="mb-4">
            <label class="block text-gray-700 text-sm font-bold mb-2">Nama Lengkap</label>
            <input type="text" name="name" value="<?= esc($biodata['name']) ?>"
                class="w-full px-3 py-2 border rounded-lg focus:outline-none focus:border-purple-500" required>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 mb-4">
            <div>
                <label class="block text-gray-700 font-medium mb-2">Email</label>
                <input type="email" name="email" value="<?= old('email', $biodata['email']) ?>"
                    class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
            </div>
            <div>
                <label class="block text-gray-700 font-medium mb-2">No. Telepon</label>
                <input type="text" name="phone" value="<?= old('phone', $biodata['phone']) ?>"
                    class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
            </div>
        </div>

        <div class="mb-4">
            <label class="block text-gray-700 font-medium mb-2">Alamat</label>
            <textarea name="address" rows="3"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none"><?= old('address', $biodata['address']) ?></textarea>
        </div>

        <div class="mb-6">
            <label class="block text-gray-700 font-medium mb-2">Deskripsi Singkat</label>
            <textarea name="summary" rows="5"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none"><?= old('summary', $biodata['summary']) ?></textarea>
        </div>

        <div class="flex justify-end gap-2">
            <a href="/admin/biodata" class="px-4 py-2 text-gray-600 hover:bg-gray-100 rounded">Batal</a>
            <button type="submit"
                class="px-6 py-2 bg-purple-600 text-white rounded hover:bg-purple-700 shadow">Update</button>
        </div>
    </form>
</div>

<?= $this->endSection() ?>