<?= $this->extend('layout/backend') ?>

<?= $this->section('content') ?>

<div class="max-w-2xl mx-auto bg-white p-8 rounded-lg shadow">
    <h2 class="text-2xl font-bold mb-6 text-gray-800">Edit Aktivitas</h2>

    <form action="/admin/activity/<?= $activity['id'] ?>" method="post" enctype="multipart/form-data">
        <input type="hidden" name="_method" value="PUT">

        <div class="mb-4">
            <label class="block text-gray-700 font-medium mb-2">Tanggal</label>
            <input type="date" name="date" value="<?= old('date', $activity['date']) ?>"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
        </div>

        <div class="mb-4">
            <label class="block text-gray-700 font-medium mb-2">Jam</label>
            <input type="time" name="time" value="<?= old('time', $activity['time']) ?>"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none">
        </div>

        <div class="mb-4">
            <label class="block text-gray-700 font-medium mb-2">Nama Aktivitas</label>
            <textarea name="activity_name" rows="3"
                class="w-full border p-2 rounded focus:ring focus:ring-purple-200 outline-none"><?= old('activity_name', $activity['activity_name']) ?></textarea>
        </div>

        <div class="mb-6">
            <label class="block text-gray-700 font-medium mb-2">Ganti Foto / Video (Opsional)</label>
            <?php if ($activity['media_path']): ?>
                <div class="mb-2 text-sm text-green-600">Terupload: <?= $activity['media_path'] ?></div>
            <?php endif; ?>
            <input type="file" name="file_upload" class="w-full border p-2 rounded bg-gray-50">
        </div>

        <div class="flex justify-end gap-2">
            <a href="/admin/activity" class="px-4 py-2 text-gray-600 hover:bg-gray-100 rounded">Batal</a>
            <button type="submit"
                class="px-6 py-2 bg-purple-600 text-white rounded hover:bg-purple-700 shadow">Update</button>
        </div>
    </form>
</div>

<?= $this->endSection() ?>