<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class EducationSeeder extends Seeder
{
    public function run()
    {
        $data = [
            [
                'level'       => 'SD',
                'school_name' => 'SD Tigaraksa 4',
                'start_year'  => '2011',
                'end_year'    => '2017',
                'description' => null,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'level'       => 'SMP',
                'school_name' => 'SMP Negri 3 Solear',
                'start_year'  => '2017',
                'end_year'    => '2020',
                'description' => null,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'level'       => 'SMA',
                'school_name' => 'SMA Negri 6 Kab Tangerang',
                'start_year'  => '2020',
                'end_year'    => '2023',
                'description' => null,
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
            [
                'level'       => 'S1',
                'school_name' => 'Universitas Yatsi Madani',
                'start_year'  => '2023',
                'end_year'    => '2027',
                'description' => 'Semester 5',
                'created_at'  => date('Y-m-d H:i:s'),
                'updated_at'  => date('Y-m-d H:i:s'),
            ],
        ];

        // Ensure table is clean before seeding to prevent duplicates if run multiple times
        // $this->db->table('education_history')->truncate(); 
        // Commented out truncate to be safe, but since it's empty it's fine. 
        // Actually, if I run this and it fails halfway, re-running might duplicate. 
        // But for now, assuming empty table as per user screenshot.
        
        $this->db->table('education_history')->insertBatch($data);
    }
}
