<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddPhotoToBiodata extends Migration
{
    public function up()
    {
        $fields = [
            'photo' => [
                'type' => 'VARCHAR',
                'constraint' => 255,
                'null' => true,
                'after' => 'summary',
            ],
        ];
        $this->forge->addColumn('biodata', $fields);
    }

    public function down()
    {
        $this->forge->dropColumn('biodata', 'photo');
    }
}
