<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateDefaultTables extends Migration
{
    public function up()
    {
        // 1. Daily Activities Table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'date' => [
                'type' => 'DATE',
            ],
            'time' => [
                'type' => 'TIME',
            ],
            'activity_name' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],
            'media_path' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('daily_activities');

        // 2. Biodata Table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'name' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'address' => [
                'type' => 'TEXT',
            ],
            'phone' => [
                'type' => 'VARCHAR',
                'constraint' => '20',
            ],
            'email' => [
                'type' => 'VARCHAR',
                'constraint' => '100',
            ],
            'summary' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('biodata');

        // 3. Education History Table
        $this->forge->addField([
            'id' => [
                'type' => 'INT',
                'constraint' => 11,
                'unsigned' => true,
                'auto_increment' => true,
            ],
            'level' => [
                'type' => 'ENUM',
                'constraint' => ['SD', 'SMP', 'SMA', 'D3', 'S1', 'S2', 'S3'],
                'default' => 'SD',
            ],
            'school_name' => [
                'type' => 'VARCHAR',
                'constraint' => '255',
            ],
            'start_year' => [
                'type' => 'YEAR',
            ],
            'end_year' => [
                'type' => 'YEAR',
            ],
            'description' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        $this->forge->addKey('id', true);
        $this->forge->createTable('education_history');
    }

    public function down()
    {
        $this->forge->dropTable('daily_activities');
        $this->forge->dropTable('biodata');
        $this->forge->dropTable('education_history');
    }
}
