<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\EducationModel;

class Education extends BaseController
{
    protected $educationModel;

    public function __construct()
    {
        $this->educationModel = new EducationModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search');
        $sort = $this->request->getGet('sort') ?? 'start_year'; // Default sort by year
        $order = $this->request->getGet('order') ?? 'DESC';

        $model = $this->educationModel;

        if ($search) {
            $model->like('school_name', $search)
                ->orLike('level', $search);
        }

        $data = [
            'education' => $model->orderBy($sort, $order)->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'sort' => $sort,
            'order' => $order,
        ];

        return view('admin/education/index', $data);
    }

    public function new()
    {
        return view('admin/education/create');
    }

    public function create()
    {
        $data = [
            'level' => $this->request->getPost('level'),
            'school_name' => $this->request->getPost('school_name'),
            'start_year' => $this->request->getPost('start_year'),
            'end_year' => $this->request->getPost('end_year'),
            'description' => $this->request->getPost('description'),
        ];

        if (!$this->educationModel->save($data)) {
            return redirect()->back()->withInput()->with('errors', $this->educationModel->errors());
        }

        return redirect()->to('/admin/education')->with('message', 'Education added successfully');
    }

    public function edit($id = null)
    {
        $data['education'] = $this->educationModel->find($id);
        if (!$data['education']) {
            return redirect()->to('/admin/education')->with('error', 'Item not found');
        }
        return view('admin/education/edit', $data);
    }

    public function update($id = null)
    {
        $data = [
            'id' => $id,
            'level' => $this->request->getPost('level'),
            'school_name' => $this->request->getPost('school_name'),
            'start_year' => $this->request->getPost('start_year'),
            'end_year' => $this->request->getPost('end_year'),
            'description' => $this->request->getPost('description'),
        ];

        if (!$this->educationModel->save($data)) {
            return redirect()->back()->withInput()->with('errors', $this->educationModel->errors());
        }

        return redirect()->to('/admin/education')->with('message', 'Education updated successfully');
    }

    public function delete($id = null)
    {
        $this->educationModel->delete($id);
        return redirect()->to('/admin/education')->with('message', 'Education deleted successfully');
    }
}
