<?php

namespace App\Controllers\Admin;

use App\Controllers\BaseController;
use App\Models\ActivityModel;

class Activity extends BaseController
{
    protected $activityModel;

    public function __construct()
    {
        $this->activityModel = new ActivityModel();
    }

    public function index()
    {
        $search = $this->request->getGet('search');
        $sort = $this->request->getGet('sort') ?? 'id';
        $order = $this->request->getGet('order') ?? 'DESC';

        $model = $this->activityModel;

        if ($search) {
            $model->like('activity_name', $search)
                ->orLike('date', $search);
        }

        $data = [
            'activities' => $model->orderBy($sort, $order)->paginate(10),
            'pager' => $model->pager,
            'search' => $search,
            'sort' => $sort,
            'order' => $order,
        ];

        return view('admin/activity/index', $data);
    }

    public function new()
    {
        return view('admin/activity/create');
    }

    public function create()
    {
        $rules = [
            'date' => 'required|valid_date',
            'time' => 'required',
            'activity_name' => 'required',
            'file_upload' => 'uploaded[file_upload]|max_size[file_upload,10240]|is_image[file_upload]', // Optional checking handled below
        ];

        // Handle File Upload manually to start simple or strict
        // Note: The requirement mentions Photo/Video.

        $file = $this->request->getFile('file_upload');
        $fileName = '';

        if ($file && $file->isValid() && !$file->hasMoved()) {
            $fileName = $file->getRandomName();
            $file->move(FCPATH . 'uploads/activities', $fileName);
        }

        $data = [
            'date' => $this->request->getPost('date'),
            'time' => $this->request->getPost('time'),
            'activity_name' => $this->request->getPost('activity_name'),
            'media_path' => $fileName,
        ];

        if (!$this->activityModel->save($data)) {
            return redirect()->back()->withInput()->with('errors', $this->activityModel->errors());
        }

        return redirect()->to('/admin/activity')->with('message', 'Activity created successfully');
    }

    public function edit($id = null)
    {
        $data['activity'] = $this->activityModel->find($id);
        if (!$data['activity']) {
            return redirect()->to('/admin/activity')->with('error', 'Activity not found');
        }
        return view('admin/activity/edit', $data);
    }

    public function update($id = null)
    {
        $file = $this->request->getFile('file_upload');
        $data = [
            'id' => $id,
            'date' => $this->request->getPost('date'),
            'time' => $this->request->getPost('time'),
            'activity_name' => $this->request->getPost('activity_name'),
        ];

        if ($file && $file->isValid() && !$file->hasMoved()) {
            $fileName = $file->getRandomName();
            $file->move(FCPATH . 'uploads/activities', $fileName);
            $data['media_path'] = $fileName;
        }

        if (!$this->activityModel->save($data)) {
            return redirect()->back()->withInput()->with('errors', $this->activityModel->errors());
        }

        return redirect()->to('/admin/activity')->with('message', 'Activity updated successfully');
    }

    public function delete($id = null)
    {
        $this->activityModel->delete($id);
        return redirect()->to('/admin/activity')->with('message', 'Activity deleted successfully');
    }
}
