<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>

<h2 class="section-heading">Riwayat Pendidikan</h2>

<div class="search-filter-section">
    <form method="get" action="<?= base_url('education') ?>" class="w-100">
        <div class="row">
            <div class="col-md-4 mb-2">
                <input type="text" name="search" class="form-control" placeholder="Cari sekolah atau jurusan..." value="<?= esc($search) ?>">
            </div>
            <div class="col-md-3 mb-2">
                <select name="filter_jenjang" class="form-control">
                    <option value="">Semua Jenjang</option>
                    <option value="SD" <?= $filter_jenjang == 'SD' ? 'selected' : '' ?>>SD</option>
                    <option value="SMP" <?= $filter_jenjang == 'SMP' ? 'selected' : '' ?>>SMP</option>
                    <option value="SMA" <?= $filter_jenjang == 'SMA' ? 'selected' : '' ?>>SMA</option>
                    <option value="S1" <?= $filter_jenjang == 'S1' ? 'selected' : '' ?>>S1</option>
                    <option value="S2" <?= $filter_jenjang == 'S2' ? 'selected' : '' ?>>S2</option>
                    <option value="S3" <?= $filter_jenjang == 'S3' ? 'selected' : '' ?>>S3</option>
                </select>
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="btn btn-primary w-100">Cari</button>
            </div>
            <div class="col-md-3 mb-2">
                <a href="<?= base_url('education') ?>" class="btn btn-secondary w-100">Reset</a>
            </div>
        </div>
    </form>
</div>

<div class="sorting-links">
    <small><strong>Urutkan:</strong></small>
    <a href="<?= base_url('education?sort_by=tahun_mulai&sort_order=' . ($sort_by == 'tahun_mulai' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>">
        Tahun Mulai <?= $sort_by == 'tahun_mulai' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
    <a href="<?= base_url('education?sort_by=tahun_selesai&sort_order=' . ($sort_by == 'tahun_selesai' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>">
        Tahun Selesai <?= $sort_by == 'tahun_selesai' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
    <a href="<?= base_url('education?sort_by=jenjang&sort_order=' . ($sort_by == 'jenjang' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>">
        Jenjang <?= $sort_by == 'jenjang' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
    <a href="<?= base_url('education?sort_by=nama_sekolah&sort_order=' . ($sort_by == 'nama_sekolah' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>">
        Nama Sekolah <?= $sort_by == 'nama_sekolah' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
</div>

<?php if (empty($educations)): ?>
    <div class="alert alert-info">Tidak ada data riwayat pendidikan.</div>
<?php else: ?>
    <div class="education-timeline">
        <?php foreach ($educations as $edu): ?>
            <div class="timeline-item">
                <div class="timeline-card">
                    <div class="timeline-meta"><?= esc($edu['tahun_mulai']) ?> - <?= esc($edu['tahun_selesai']) ?> · <?= esc($edu['jenjang']) ?></div>
                    <h3 class="timeline-title"><?= esc($edu['nama_sekolah']) ?></h3>
                    <p class="mb-1 text-muted"><?= esc($edu['jurusan']) ?> — IPK: <?= esc($edu['ipk']) ?></p>
                    <?php if (!empty($edu['keterangan'])): ?>
                        <p class="mb-0"><?= esc($edu['keterangan']) ?></p>
                    <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </div>

    <div class="mt-4">
        <?= $pager->links() ?>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>



