<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<h2 class="mb-4">Preview Biodata</h2>

<div class="card">
    <div class="card-body">
        <div class="row">
            <div class="col-md-3">
                <?php if (!empty($biodata['foto_profil'])): ?>
                    <img src="<?= base_url($biodata['foto_profil']) ?>" class="img-fluid rounded" alt="Foto Profil">
                <?php else: ?>
                    <div class="bg-secondary text-white p-5 text-center rounded">No Photo</div>
                <?php endif; ?>
            </div>
            <div class="col-md-9">
                <h5 class="card-title"><?= esc($biodata['nama']) ?></h5>
                <p class="card-text">
                    <strong>Alamat:</strong> <?= esc($biodata['alamat']) ?><br>
                    <strong>Tempat, Tanggal Lahir:</strong> <?= esc($biodata['tempat_lahir']) ?>, <?= $biodata['tanggal_lahir'] ? date('d-m-Y', strtotime($biodata['tanggal_lahir'])) : '' ?><br>
                    <strong>Jenis Kelamin:</strong> <?= esc($biodata['jenis_kelamin']) ?><br>
                    <strong>Agama:</strong> <?= esc($biodata['agama']) ?><br>
                    <strong>No. HP:</strong> <?= esc($biodata['no_hp']) ?><br>
                    <strong>Email:</strong> <?= esc($biodata['email']) ?><br>
                    <?php if (!empty($biodata['deskripsi'])): ?>
                        <strong>Deskripsi:</strong><br>
                        <?= esc($biodata['deskripsi']) ?>
                    <?php endif; ?>
                </p>
            </div>
        </div>
        <a href="<?= base_url('admin/biodata') ?>" class="btn btn-secondary">Kembali</a>
    </div>
</div>

<?= $this->endSection() ?>







