<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<h2 class="mb-4">Preview Aktivitas</h2>

<div class="card">
    <div class="card-body">
        <h5 class="card-title"><?= esc($activity['nama_aktivitas']) ?></h5>
        <p class="card-text">
            <strong>Tanggal:</strong> <?= date('d-m-Y', strtotime($activity['tanggal'])) ?><br>
            <strong>Jam:</strong> <?= date('H:i', strtotime($activity['jam'])) ?>
        </p>
        <?php if (!empty($activity['foto'])): ?>
            <div class="mb-3">
                <strong>Foto:</strong><br>
                <img src="<?= base_url($activity['foto']) ?>" class="img-fluid" alt="Foto Aktivitas" style="max-height: 400px;">
            </div>
        <?php endif; ?>
        <?php if (!empty($activity['video'])): ?>
            <div class="mb-3">
                <strong>Video:</strong><br>
                <video width="100%" controls>
                    <source src="<?= base_url($activity['video']) ?>" type="video/mp4">
                    Browser Anda tidak mendukung video tag.
                </video>
            </div>
        <?php endif; ?>
        <a href="<?= base_url('admin/activities') ?>" class="btn btn-secondary">Kembali</a>
    </div>
</div>

<?= $this->endSection() ?>







