<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="admin-page-header">
    <h1>Data Riwayat Pendidikan</h1>
</div>

<div class="admin-card">
    <a href="<?= base_url('admin/education/new') ?>" class="admin-btn admin-btn-primary mb-3">Tambah Riwayat Pendidikan Baru</a>

    <!-- Search and Filter Form -->
    <form method="get" action="<?= base_url('admin/education') ?>" class="mb-4">
        <div class="row">
            <div class="col-md-4 mb-2">
                <input type="text" name="search" class="admin-form-control" placeholder="Cari sekolah atau jurusan..." value="<?= esc($search) ?>">
            </div>
            <div class="col-md-3 mb-2">
                <select name="filter_jenjang" class="admin-form-control">
                    <option value="">Semua Jenjang</option>
                    <option value="SD" <?= $filter_jenjang == 'SD' ? 'selected' : '' ?>>SD</option>
                    <option value="SMP" <?= $filter_jenjang == 'SMP' ? 'selected' : '' ?>>SMP</option>
                    <option value="SMA" <?= $filter_jenjang == 'SMA' ? 'selected' : '' ?>>SMA</option>
                    <option value="S1" <?= $filter_jenjang == 'S1' ? 'selected' : '' ?>>S1</option>
                    <option value="S2" <?= $filter_jenjang == 'S2' ? 'selected' : '' ?>>S2</option>
                    <option value="S3" <?= $filter_jenjang == 'S3' ? 'selected' : '' ?>>S3</option>
                </select>
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="admin-btn admin-btn-primary w-100">Cari</button>
            </div>
            <div class="col-md-3 mb-2">
                <a href="<?= base_url('admin/education') ?>" class="admin-btn admin-btn-secondary w-100">Reset</a>
            </div>
        </div>
    </form>

    <!-- Sorting Links -->
    <div class="mb-3 admin-sort-links">
        <small><strong>Urutkan berdasarkan:</strong></small>
        <a href="<?= base_url('admin/education?sort_by=tahun_mulai&sort_order=' . ($sort_by == 'tahun_mulai' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>">
            Tahun Mulai <?= $sort_by == 'tahun_mulai' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a> |
        <a href="<?= base_url('admin/education?sort_by=tahun_selesai&sort_order=' . ($sort_by == 'tahun_selesai' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>">
            Tahun Selesai <?= $sort_by == 'tahun_selesai' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a> |
        <a href="<?= base_url('admin/education?sort_by=jenjang&sort_order=' . ($sort_by == 'jenjang' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>">
            Jenjang <?= $sort_by == 'jenjang' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a> |
        <a href="<?= base_url('admin/education?sort_by=nama_sekolah&sort_order=' . ($sort_by == 'nama_sekolah' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_jenjang=' . urlencode($filter_jenjang)) ?>">
            Nama Sekolah <?= $sort_by == 'nama_sekolah' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
    </div>
</div>

<div class="admin-card">
    <table class="admin-table">
<thead>
<tr>
    <th>#</th>
    <th>Jenjang</th>
    <th>Nama Sekolah</th>
    <th>Jurusan</th>
    <th>Tahun Mulai</th>
    <th>Tahun Selesai</th>
    <th>IPK</th>
    <th>Action</th>
</tr>
</thead>
<tbody>
<?php 
$page = $pager->getCurrentPage() ?? 1;
$perPage = 10; 
$no = ($page - 1) * $perPage + 1;
?>
<?php foreach($educations as $edu): ?>
<tr>
    <td><?= $no++ ?></td>
    <td><?= esc($edu['jenjang']) ?></td>
    <td><?= esc($edu['nama_sekolah']) ?></td>
    <td><?= esc($edu['jurusan']) ?></td>
    <td><?= esc($edu['tahun_mulai']) ?></td>
    <td><?= esc($edu['tahun_selesai']) ?></td>
    <td><?= esc($edu['ipk']) ?></td>
    <td style="white-space: nowrap; width: 1%;">
        <a href="<?= base_url('education') ?>" class="admin-btn admin-btn-secondary" style="padding: 0.3rem 0.6rem; font-size: 0.85rem;" target="_blank">Preview</a>
        <a href="<?= base_url('admin/education/'.$edu['id'].'/edit') ?>" class="admin-btn admin-btn-success" style="padding: 0.3rem 0.6rem; font-size: 0.85rem;">Edit</a>
        <a href="#" data-href="<?= base_url('admin/education/'.$edu['id'].'/delete') ?>" onclick="confirmToDelete(this)" class="admin-btn admin-btn-danger" style="padding: 0.3rem 0.6rem; font-size: 0.85rem;">Delete</a>
    </td>
</tr>
<?php endforeach ?>
</tbody>
    </table>
</div>

<!-- Pagination -->
<div class="mt-4">
    <?= $pager->links() ?>
</div>

<div id="confirm-dialog" class="modal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-body">
        <h2 class="h2">Are you sure?</h2>
        <p>The data will be deleted and lost forever</p>
      </div>
      <div class="modal-footer">
        <a href="#" role="button" id="delete-button" class="admin-btn admin-btn-danger">Delete</a>
        <button type="button" class="admin-btn admin-btn-secondary" data-dismiss="modal">Cancel</button>
      </div>
    </div>
  </div>
</div>

<script>
function confirmToDelete(el){
    $("#delete-button").attr("href", el.dataset.href);
    $("#confirm-dialog").modal('show');
}
</script>

<?= $this->endSection() ?>







