<?= $this->extend('layout/admin/admin_layout') ?>

<?= $this->section('content') ?>

<div class="admin-page-header">
    <h1>Data Aktivitas Harian</h1>
</div>

<div class="admin-card">
    <a href="<?= base_url('admin/activities/new') ?>" class="admin-btn admin-btn-primary mb-3">Tambah Aktivitas Baru</a>

    <!-- Search and Filter Form -->
    <form method="get" action="<?= base_url('admin/activities') ?>" class="mb-4">
        <div class="row">
            <div class="col-md-4 mb-2">
                <input type="text" name="search" class="admin-form-control" placeholder="Cari aktivitas..." value="<?= esc($search) ?>">
            </div>
            <div class="col-md-3 mb-2">
                <input type="date" name="filter_tanggal" class="admin-form-control" value="<?= esc($filter_tanggal) ?>">
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="admin-btn admin-btn-primary w-100">Cari</button>
            </div>
            <div class="col-md-3 mb-2">
                <a href="<?= base_url('admin/activities') ?>" class="admin-btn admin-btn-secondary w-100">Reset</a>
            </div>
        </div>
    </form>

    <!-- Sorting Links -->
    <div class="mb-3 admin-sort-links">
        <small><strong>Urutkan berdasarkan:</strong></small>
        <a href="<?= base_url('admin/activities?sort_by=tanggal&sort_order=' . ($sort_by == 'tanggal' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>">
            Tanggal <?= $sort_by == 'tanggal' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a> |
        <a href="<?= base_url('admin/activities?sort_by=jam&sort_order=' . ($sort_by == 'jam' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>">
            Jam <?= $sort_by == 'jam' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a> |
        <a href="<?= base_url('admin/activities?sort_by=nama_aktivitas&sort_order=' . ($sort_by == 'nama_aktivitas' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>">
            Nama Aktivitas <?= $sort_by == 'nama_aktivitas' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
        </a>
    </div>
</div>

<div class="admin-card">
    <table class="admin-table">
<thead>
<tr>
    <th>#</th>
    <th>Tanggal</th>
    <th>Jam</th>
    <th>Nama Aktivitas</th>
    <th>Foto</th>
    <th>Video</th>
    <th>Action</th>
</tr>
</thead>
<tbody>
<?php 
$page = $pager->getCurrentPage() ?? 1;
$perPage = 10; 
$no = ($page - 1) * $perPage + 1;
?>
<?php foreach($activities as $activity): ?>
<tr>
    <td><?= $no++ ?></td>
    <td><?= date('d-m-Y', strtotime($activity['tanggal'])) ?></td>
    <td><?= date('H:i', strtotime($activity['jam'])) ?></td>
    <td><?= esc($activity['nama_aktivitas']) ?></td>
    <td>
        <?php if (!empty($activity['foto'])): ?>
            <img src="<?= base_url($activity['foto']) ?>" style="max-width: 100px; max-height: 100px;" alt="Foto">
        <?php else: ?>
            <span class="text-muted">-</span>
        <?php endif; ?>
    </td>
    <td>
        <?php if (!empty($activity['video'])): ?>
            <span class="text-success">✓ Ada</span>
        <?php else: ?>
            <span class="text-muted">-</span>
        <?php endif; ?>
    </td>
    <td style="white-space: nowrap; width: 1%;">
        <a href="<?= base_url('activities') ?>" class="admin-btn admin-btn-secondary" target="_blank" style="padding: 0.3rem 0.6rem; font-size: 0.85rem;">Preview</a>
        <a href="<?= base_url('admin/activities/'.$activity['id'].'/edit') ?>" class="admin-btn admin-btn-success" style="padding: 0.3rem 0.6rem; font-size: 0.85rem;">Edit</a>
        <a href="#" data-href="<?= base_url('admin/activities/'.$activity['id'].'/delete') ?>" onclick="confirmToDelete(this)" class="admin-btn admin-btn-danger" style="padding: 0.3rem 0.6rem; font-size: 0.85rem;">Delete</a>
    </td>
</tr>
<?php endforeach ?>
</tbody>
    </table>
</div>

<!-- Pagination -->
<div class="mt-4">
    <?= $pager->links() ?>
</div>

<div id="confirm-dialog" class="modal" tabindex="-1" role="dialog">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-body">
        <h2 class="h2">Are you sure?</h2>
        <p>The data will be deleted and lost forever</p>
      </div>
      <div class="modal-footer">
        <a href="#" role="button" id="delete-button" class="admin-btn admin-btn-danger">Delete</a>
        <button type="button" class="admin-btn admin-btn-secondary" data-dismiss="modal">Cancel</button>
      </div>
    </div>
  </div>
</div>

<script>
function confirmToDelete(el){
    $("#delete-button").attr("href", el.dataset.href);
    $("#confirm-dialog").modal('show');
}
</script>

<?= $this->endSection() ?>



