<?= $this->extend('layout/post_layout') ?>

<?= $this->section('content') ?>

<h2 class="section-heading">Aktivitas Harian</h2>

<div class="search-filter-section">
    <form method="get" action="<?= base_url('activities') ?>" class="w-100">
        <div class="row">
            <div class="col-md-4 mb-2">
                <input type="text" name="search" class="form-control" placeholder="Cari aktivitas..." value="<?= esc($search) ?>">
            </div>
            <div class="col-md-3 mb-2">
                <input type="date" name="filter_tanggal" class="form-control" value="<?= esc($filter_tanggal) ?>">
            </div>
            <div class="col-md-2 mb-2">
                <button type="submit" class="btn btn-primary w-100">Cari</button>
            </div>
            <div class="col-md-3 mb-2">
                <a href="<?= base_url('activities') ?>" class="btn btn-secondary w-100">Reset</a>
            </div>
        </div>
    </form>
</div>

<div class="sorting-links">
    <small><strong>Urutkan:</strong></small>
    <a href="<?= base_url('activities?sort_by=tanggal&sort_order=' . ($sort_by == 'tanggal' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>">
        Tanggal <?= $sort_by == 'tanggal' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
    <a href="<?= base_url('activities?sort_by=jam&sort_order=' . ($sort_by == 'jam' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>">
        Jam <?= $sort_by == 'jam' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
    <a href="<?= base_url('activities?sort_by=nama_aktivitas&sort_order=' . ($sort_by == 'nama_aktivitas' && $sort_order == 'ASC' ? 'DESC' : 'ASC') . '&search=' . urlencode($search) . '&filter_tanggal=' . urlencode($filter_tanggal)) ?>">
        Nama Aktivitas <?= $sort_by == 'nama_aktivitas' ? ($sort_order == 'ASC' ? '↑' : '↓') : '' ?>
    </a>
</div>

<?php if (empty($activities)): ?>
    <div class="alert alert-info">Tidak ada data aktivitas.</div>
<?php else: ?>
    <?php foreach ($activities as $activity): ?>
        <article class="activity-card">
            <div class="activity-details flex-fill">
                <div class="activity-meta"><?= date('d M Y', strtotime($activity['tanggal'])) ?> · <?= date('H:i', strtotime($activity['jam'])) ?></div>
                <h3 class="activity-title"><?= esc($activity['nama_aktivitas']) ?></h3>
                <?php if (!empty($activity['deskripsi'] ?? null)): ?>
                    <p class="mb-0 text-muted"><?= esc($activity['deskripsi']) ?></p>
                <?php endif; ?>
            </div>
            <div class="activity-media">
                <?php if (!empty($activity['foto'])): ?>
                    <img src="<?= base_url($activity['foto']) ?>" alt="Foto Aktivitas">
                <?php endif; ?>
                <?php if (!empty($activity['video'])): ?>
                    <video controls>
                        <source src="<?= base_url($activity['video']) ?>" type="video/mp4">
                        Browser Anda tidak mendukung video.
                    </video>
                <?php endif; ?>
            </div>
        </article>
    <?php endforeach; ?>

    <div class="mt-4">
        <?= $pager->links() ?>
    </div>
<?php endif; ?>

<?= $this->endSection() ?>



